#Requires AutoHotkey v2.0
#SingleInstance Force

; ---------------------------------------------------
; Performance & Environment Setup (Ignore these settings)
; ---------------------------------------------------
; These settings help the script run as fast as possible. (No need to make changes to these settings)
ProcessSetPriority("Realtime")            ; Set process priority to Realtime for minimal delays.
A_MaxHotkeysPerInterval := 99000000         ; Increase max hotkeys per interval.
A_HotkeyInterval := 99000000                ; Increase hotkey interval.
KeyHistory(0)                             ; Disable key history.
ListLines(0)                              ; Disable listing of script lines.
SetKeyDelay(-1, -1)                       ; Set key delay to "instant".
SetMouseDelay(-1)                         ; Set mouse delay to "instant".
SetDefaultMouseSpeed(0)                   ; Set mouse speed to maximum.
SetWinDelay(-1)                           ; Set window delay to "instant".
SetControlDelay(-1)                       ; Set control delay to "instant".
CoordMode("Pixel", "Screen")              ; Use screen coordinates for pixel commands.
; ---------------------------------------------------


; ---------------------------------------------------
; Configuration Section (Main settings that can be changed)
; ---------------------------------------------------
; To configure the scripts behavior, change the values below.
color := 0x28BD59      ; Target color (in hexadecimal RGB). (Color of the green shield icon) If you are using mods that change the games color then take a screenshot of the perfect block shield and put it into paint and finds its color then put that color here.
variation := 5             ; Allowed color variation/tolerance. (If you are using reshade mods or mods that change the games color then you may need to raise this number.
searchWidth := 900           ; Width (in pixels) of the search region.
searchHeight := 900           ; Height (in pixels) of the search region.
; ---------------------------------------------------



; Retrieve current screen dimensions. (Allows the script to work in other resolutions but you must run the game in Fullscreen)
screenWidth := A_ScreenWidth
screenHeight := A_ScreenHeight

; Calculate the top-left coordinates of a region centered on the screen. (Makes sure that the search area is at the center of the screen)
startX := (screenWidth // 2) - (searchWidth // 2)   ; X-coordinate of the search region.
startY := (screenHeight // 2) - (searchHeight // 2)   ; Y-coordinate of the search region.


; ---------------------------------------------------
; Static Hotkey Definition
; ---------------------------------------------------
; The following hotkey is defined statically as "~*f::".
; The "~*" prefix means:
;   - "~" lets the original key function normally (its native action isnt blocked).
;   - "*" makes the hotkey fire regardless of any other modifiers.
;
; IMPORTANT: To change the activation key, you must update BOTH the hotkey label below
; (e.g. replace "~*f::" with "~*g::") AND the key used in GetKeyState() inside the loop.
;
; For example, if you want to change the activation key to "g":
;   - Change the hotkey label from "~*f::" to "~*g::"
;   - Change GetKeyState("f", "P") to GetKeyState("g", "P")

; The hotkey routine will keep checking as long as the activation key is held down.
; Update both instances of "f" below if you change the activation key.

;An example of what the script would look like if you wanted to use the letter g to activate the script.

;~*g::{
;    while GetKeyState("g", "P") {


;Perfect Block and Riposte   -Hold F to activate
~*f::{
    while GetKeyState("f", "P") {
        if PixelSearch(&foundX, &foundY, startX, startY, startX + searchWidth - 1, startY + searchHeight - 1, color, variation) {
            SendInput("{RButton Down}")
            Sleep 80
            SendInput("{RButton Up}")
            Sleep 20
            SendInput("{LButton Down}")
            Sleep 80
            SendInput("{LButton Up}")
            Sleep 150
            SendInput("{LButton Down}")     ;Some animations from Perfect Block to Riposte take longer so extra Left mouse click for consistency.
            Sleep 80
            SendInput("{LButton Up}")
        }
        Sleep 1   ;Prevent loop from consuming too much CPU
    }
}


;Perfect Block attack / Master Strike (If attack is from opposite direction to enemies attack)  -Hold E to activate
~*e::{
    while GetKeyState("e", "P") {
        if PixelSearch(&foundX, &foundY, startX, startY, startX + searchWidth - 1, startY + searchHeight - 1, color, variation) {
            SendInput("{LButton Down}")
            Sleep 80
            SendInput("{LButton Up}")
            Sleep 150
        }
        Sleep 1   ;Prevent loop from consuming too much CPU
    }
}

; ---------------------------------------------------
; Exit Script Hotkey
; ---------------------------------------------------
; Press F8 at any time to exit the script.
F8::ExitApp
